% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_3cmt.R
\name{calc_sd_3cmt}
\alias{calc_sd_3cmt}
\alias{calc_sd_3cmt_linear_bolus}
\alias{calc_sd_3cmt_linear_oral_1_lag}
\alias{calc_sd_3cmt_linear_infusion}
\alias{calc_sd_3cmt_linear_oral_0}
\alias{calc_sd_3cmt_linear_oral_0_lag}
\alias{calc_sd_3cmt_linear_oral_1}
\title{Calculate C(t) for a 3-compartment linear model}
\usage{
calc_sd_3cmt(t, dose, dur = NULL, tinf = NULL, ...)

calc_sd_3cmt_linear_bolus(t, dose, ...)

calc_sd_3cmt_linear_oral_1_lag(t, dose, ...)

calc_sd_3cmt_linear_infusion(t, dose, tinf, ...)

calc_sd_3cmt_linear_oral_0(t, dose, dur, ...)

calc_sd_3cmt_linear_oral_0_lag(t, dose, dur, ...)

calc_sd_3cmt_linear_oral_1(t, dose, ...)
}
\arguments{
\item{t}{Time after dose (h)}

\item{dose}{Dose}

\item{dur}{Duration of zero-order absorption (h)}

\item{tinf}{Duration of infusion (h)}

\item{...}{Passed to \code{calc_derived_3cpt()}}
}
\value{
Concentration of drug at requested time (\code{t}) after a single dose, given provided set of parameters and variables.
}
\description{
Calculate C(t) for a 3-compartment linear model
}
\section{Functions}{
\itemize{
\item \code{calc_sd_3cmt_linear_bolus()}: Calculate C(t) for a 3-compartment linear model after a single IV bolus dose

\item \code{calc_sd_3cmt_linear_oral_1_lag()}: Calculate C(t) for a 3-compartment linear model after a single oral dose

\item \code{calc_sd_3cmt_linear_infusion()}: Calculate C(t) for a 3-compartment linear model after a single IV infusion

\item \code{calc_sd_3cmt_linear_oral_0()}: Calculate C(t) for a 3-compartment linear model after a single dose, with zero-order absorption

\item \code{calc_sd_3cmt_linear_oral_0_lag()}: Calculate C(t) for a 3-compartment linear model after a single dose, with zero-order absorption and a lag time

\item \code{calc_sd_3cmt_linear_oral_1()}: Calculate C(t) for a 3-compartment linear model after a single oral dose

}}
\examples{
Ct <- calc_sd_3cmt_linear_bolus(t = 11.75, CL = 3.5, V1 = 20, V2 = 500,
    V3 = 200, Q2 = 0.5, Q3 = 0.05, dose = 100)
Ct <- calc_sd_3cmt_linear_oral_1_lag(t = 11.75, CL = 3.5, V1 = 20, V2 = 500,
    V3 = 200, Q2 = 0.5, Q3 = 0.05, ka = 1, dose = 100, tlag = 1.5)
Ct <- calc_sd_3cmt_linear_infusion(t = 11.75, CL = 3.5, V1 = 20, V2 = 500,
    V3 = 200, Q2 = 0.5, Q3 = 0.05, dose = 100, tinf=1)
Ct <- calc_sd_3cmt_linear_oral_0(t = 11.75, CL = 3.5, V1 = 20, V2 = 500,
    V3 = 200, Q2 = 0.5, Q3 = 0.05, dur = 1, dose = 100)
Ct <- calc_sd_3cmt_linear_oral_0_lag(t = 11.75, CL = 3.5, V1 = 20, V2 = 500,
    V3 = 200, Q2 = 0.5, Q3 = 0.05, dur = 1, dose = 100, tlag=1.5)
Ct <- calc_sd_3cmt_linear_oral_1(t = 11.75, CL = 3.5, V1 = 20, V2 = 500,
    V3 = 200, Q2 = 0.5, Q3 = 0.05, ka = 1, dose = 100)
}
\references{
Bertrand J & Mentre F (2008). Mathematical Expressions of the Pharmacokinetic and Pharmacodynamic Models
implemented in the Monolix software. \url{https://www.facm.ucl.ac.be/cooperation/Vietnam/WBI-Vietnam-October-2011/Modelling/Monolix32_PKPD_library.pdf}

Rowland M, Tozer TN. Clinical Pharmacokinetics and Pharmacodynamics: Concepts and Applications (4th). Lippincott Williams & Wilkins, Philadelphia, 2010.
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}

Bill Denney, \email{wdenney@humanpredictions.com}
}
