% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ATE.R
\name{plot_ICATE}
\alias{plot_ICATE}
\title{Plot Individual Conditional Average Treatment effects}
\usage{
plot_ICATE(.model, .group_by = NULL, n_bins = 30, .alpha = 0.7)
}
\arguments{
\item{.model}{a model produced by `bartCause::bartc()`}

\item{.group_by}{a grouping variable as a vector}

\item{n_bins}{number of bins}

\item{.alpha}{transparency of histograms}
}
\value{
ggplot object
}
\description{
Plots a histogram of Individual Conditional Average Treatment effects (ICATE).
ICATEs are the difference in each individual's predicted outcome under the treatment and predicted outcome under the control averaged over the individual.
Plots of ICATEs are useful to identify potential heterogeneous treatment effects between different individuals. ICATE plots can be grouped by discrete variables.
}
\examples{
\donttest{
data(lalonde)
confounders <- c('age', 'educ', 'black', 'hisp', 'married', 'nodegr')
model_results <- bartCause::bartc(
 response = lalonde[['re78']],
 treatment = lalonde[['treat']],
 confounders = as.matrix(lalonde[, confounders]),
 estimand = 'ate',
 commonSup.rule = 'none'
)
plot_ICATE(model_results, lalonde$married)
}
}
\author{
George Perrett
}
