% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_mlflow_tracking_server}
\alias{sagemaker_create_mlflow_tracking_server}
\title{Creates an MLflow Tracking Server using a general purpose Amazon S3
bucket as the artifact store}
\usage{
sagemaker_create_mlflow_tracking_server(
  TrackingServerName,
  ArtifactStoreUri,
  TrackingServerSize = NULL,
  MlflowVersion = NULL,
  RoleArn,
  AutomaticModelRegistration = NULL,
  WeeklyMaintenanceWindowStart = NULL,
  Tags = NULL
)
}
\arguments{
\item{TrackingServerName}{[required] A unique string identifying the tracking server name. This string is
part of the tracking server ARN.}

\item{ArtifactStoreUri}{[required] The S3 URI for a general purpose bucket to use as the MLflow Tracking
Server artifact store.}

\item{TrackingServerSize}{The size of the tracking server you want to create. You can choose
between \code{"Small"}, \code{"Medium"}, and \code{"Large"}. The default MLflow
Tracking Server configuration size is \code{"Small"}. You can choose a size
depending on the projected use of the tracking server such as the volume
of data logged, number of users, and frequency of use.

We recommend using a small tracking server for teams of up to 25 users,
a medium tracking server for teams of up to 50 users, and a large
tracking server for teams of up to 100 users.}

\item{MlflowVersion}{The version of MLflow that the tracking server uses. To see which MLflow
versions are available to use, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow.html#mlflow-create-tracking-server-how-it-works}{How it works}.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) for an IAM role in your account that the
MLflow Tracking Server uses to access the artifact store in Amazon S3.
The role should have \code{AmazonS3FullAccess} permissions. For more
information on IAM permissions for tracking server creation, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server-iam.html}{Set up IAM permissions for MLflow}.}

\item{AutomaticModelRegistration}{Whether to enable or disable automatic registration of new MLflow models
to the SageMaker Model Registry. To enable automatic model registration,
set this value to \code{True}. To disable automatic model registration, set
this value to \code{False}. If not specified, \code{AutomaticModelRegistration}
defaults to \code{False}.}

\item{WeeklyMaintenanceWindowStart}{The day and time of the week in Coordinated Universal Time (UTC) 24-hour
standard time that weekly maintenance updates are scheduled. For
example: TUE:03:30.}

\item{Tags}{Tags consisting of key-value pairs used to manage metadata for the
tracking server.}
}
\description{
Creates an MLflow Tracking Server using a general purpose Amazon S3 bucket as the artifact store. For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server.html}{Create an MLflow Tracking Server}.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_mlflow_tracking_server/} for full documentation.
}
\keyword{internal}
