% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrockagent_operations.R
\name{bedrockagent_update_agent}
\alias{bedrockagent_update_agent}
\title{Updates the configuration of an agent}
\usage{
bedrockagent_update_agent(
  agentCollaboration = NULL,
  agentId,
  agentName,
  agentResourceRoleArn,
  customOrchestration = NULL,
  customerEncryptionKeyArn = NULL,
  description = NULL,
  foundationModel,
  guardrailConfiguration = NULL,
  idleSessionTTLInSeconds = NULL,
  instruction = NULL,
  memoryConfiguration = NULL,
  orchestrationType = NULL,
  promptOverrideConfiguration = NULL
)
}
\arguments{
\item{agentCollaboration}{The agent's collaboration role.}

\item{agentId}{[required] The unique identifier of the agent.}

\item{agentName}{[required] Specifies a new name for the agent.}

\item{agentResourceRoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role with permissions to
invoke API operations on the agent.}

\item{customOrchestration}{Contains details of the custom orchestration configured for the agent.}

\item{customerEncryptionKeyArn}{The Amazon Resource Name (ARN) of the KMS key with which to encrypt the
agent.}

\item{description}{Specifies a new description of the agent.}

\item{foundationModel}{[required] The identifier for the model that you want to be used for orchestration
by the agent you create.

The \code{modelId} to provide depends on the type of model or throughput that
you use:
\itemize{
\item If you use a base model, specify the model ID or its ARN. For a list
of model IDs for base models, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/models-supported.html#model-ids-arns}{Amazon Bedrock base model IDs (on-demand throughput)}
in the Amazon Bedrock User Guide.
\item If you use an inference profile, specify the inference profile ID or
its ARN. For a list of inference profile IDs, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/inference-profiles-support.html}{Supported Regions and models for cross-region inference}
in the Amazon Bedrock User Guide.
\item If you use a provisioned model, specify the ARN of the Provisioned
Throughput. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html}{Run inference using a Provisioned Throughput}
in the Amazon Bedrock User Guide.
\item If you use a custom model, first purchase Provisioned Throughput for
it. Then specify the ARN of the resulting provisioned model. For
more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html}{Use a custom model in Amazon Bedrock}
in the Amazon Bedrock User Guide.
\item If you use an \href{https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html}{imported model},
specify the ARN of the imported model. You can get the model ARN
from a successful call to
\href{https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html}{CreateModelImportJob}
or from the Imported models page in the Amazon Bedrock console.
}}

\item{guardrailConfiguration}{The unique Guardrail configuration assigned to the agent when it is
updated.}

\item{idleSessionTTLInSeconds}{The number of seconds for which Amazon Bedrock keeps information about a
user's conversation with the agent.

A user interaction remains active for the amount of time specified. If
no conversation occurs during this time, the session expires and Amazon
Bedrock deletes any data provided before the timeout.}

\item{instruction}{Specifies new instructions that tell the agent what it should do and how
it should interact with users.}

\item{memoryConfiguration}{Specifies the new memory configuration for the agent.}

\item{orchestrationType}{Specifies the type of orchestration strategy for the agent. This is set
to \code{DEFAULT} orchestration type, by default.}

\item{promptOverrideConfiguration}{Contains configurations to override prompts in different parts of an
agent sequence. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html}{Advanced prompts}.}
}
\description{
Updates the configuration of an agent.

See \url{https://www.paws-r-sdk.com/docs/bedrockagent_update_agent/} for full documentation.
}
\keyword{internal}
