% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_operations.R
\name{codeartifact_put_domain_permissions_policy}
\alias{codeartifact_put_domain_permissions_policy}
\title{Sets a resource policy on a domain that specifies permissions to access
it}
\usage{
codeartifact_put_domain_permissions_policy(
  domain,
  domainOwner = NULL,
  policyRevision = NULL,
  policyDocument
)
}
\arguments{
\item{domain}{[required] The name of the domain on which to set the resource policy.}

\item{domainOwner}{The 12-digit account number of the Amazon Web Services account that owns
the domain. It does not include dashes or spaces.}

\item{policyRevision}{The current revision of the resource policy to be set. This revision is
used for optimistic locking, which prevents others from overwriting your
changes to the domain's resource policy.}

\item{policyDocument}{[required] A valid displayable JSON Aspen policy string to be set as the access
control resource policy on the provided domain.}
}
\description{
Sets a resource policy on a domain that specifies permissions to access it.

See \url{https://www.paws-r-sdk.com/docs/codeartifact_put_domain_permissions_policy/} for full documentation.
}
\keyword{internal}
