% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgInfo.R
\name{pkgInfo}
\alias{pkgInfo}
\title{Extract Package Information}
\usage{
pkgInfo(pkg, leaveRemains = FALSE)
}
\arguments{
\item{pkg}{The compressed (tar.gz) build file of an R package.}

\item{leaveRemains}{Keep decompressed package in temp directory.}
}
\value{
\item{Package}{Package name}
\item{Version}{Version number}
\item{Imports}{Imported packages}
\item{Suggests}{Suggested packages}
\item{ImportedFunctions}{Functions imported from other packages}
\item{ExportedFunctions}{Functions exported from package}
\item{AllFunctions}{All defined functions}
\item{FormalArgs}{Function arguments}
\item{Data}{Dimension information on data sets}
\item{documentation}{Full package documentation}
}
\description{
This function extracts information from an R package.
}
\details{
Generate package information from its build file.
}
\examples{
tarfile <- system.file("examples", "acepack_1.3-3.3.tar.gz", package = "packageDiff")
info <- pkgInfo(tarfile)
\donttest{
url <- 'https://cran.r-project.org/src/contrib/Archive/acepack/acepack_1.3-3.3.tar.gz'
info <- pkgInfo(url)
}
}
