% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locker.R
\name{version_locker}
\alias{version_locker}
\title{Version locker contents}
\usage{
version_locker(where, version = "save", overwrite = FALSE, noreset = FALSE)
}
\arguments{
\item{where}{The locker location.}

\item{version}{A tag to be appended to \code{where} for creating a backup of the
locker contents.}

\item{overwrite}{If \code{TRUE}, the new location will be removed with \code{\link[=unlink]{unlink()}}
if it exists.}

\item{noreset}{If \code{TRUE}, \code{\link[=noreset_locker]{noreset_locker()}} is called \strong{on the new version}.}
}
\value{
A logical value indicating whether or not all files were successfully copied
to the backup, invisibly.
}
\description{
Version locker contents
}
\examples{
locker <- file.path(tempdir(), "version-locker-example")

if(dir.exists(locker)) unlink(locker, recursive = TRUE)

x <- new_stream(1, locker = locker)

cat("test", file = file.path(locker, "1-1"))

dir.exists(locker)

list.files(locker, all.files = TRUE)

y <- version_locker(locker, version = "y")

y

list.files(y, all.files = TRUE)

}
\seealso{
\code{\link[=reset_locker]{reset_locker()}}, \code{\link[=noreset_locker]{noreset_locker()}}, \code{\link[=setup_locker]{setup_locker()}}
}
