% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWK_method.r
\name{PWK}
\alias{PWK}
\title{Proportion-weighted k-nearest neighbor}
\usage{
PWK(train, y, test, alpha=1, n_neighbors=10)
}
\arguments{
\item{train}{a \code{data.frame} containing the training data.}

\item{y}{a \code{vector} containing the target values.}

\item{test}{a \code{data.frame} containing the test data.}

\item{alpha}{a numeric value defining the proportion-weighted k-nearest neighbor algorithm
as proposed by Barranquero et al., (2012). (Default: \code{1}).}

\item{n_neighbors}{a integer value defining the number of neighbors to use by default for
nearest neighbor queries (Default: \code{10}).}
}
\value{
A numeric vector containing the class distribution estimated from the test set.
}
\description{
It is a nearest-neighbor classifier adapted for working over quantification problems. This
method applies a weighting scheme, reducing the weight on neighbors from the majority class.
}
\examples{
library(caret)
library(FNN)
cv <- createFolds(aeAegypti$class, 2)
tr <- aeAegypti[cv$Fold1,]
ts <- aeAegypti[cv$Fold2,]

# -- Getting a sample from ts with 80 positive and 20 negative instances --
ts_sample <- rbind(ts[sample(which(ts$class==1),80),],
                   ts[sample(which(ts$class==2),20),])
PWK(train=tr[,-which(names(tr)=="class")], y=tr[,"class"], test= ts[,-which(names(ts)=="class")])
}
\references{
Barranquero, J., González, P., Díez, J., & Del Coz, J. J. (2013). On the study
of nearest neighbor algorithms for prevalence estimation in binary problems. Pattern Recognition,
46(2), 472-482.<doi.org/10.1016/j.patcog.2012.07.022>
}
