% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_helpers.R
\name{gt_merge_stack_team_color}
\alias{gt_merge_stack_team_color}
\title{Merge and stack text from two columns in \code{gt} and color one with team colors}
\usage{
gt_merge_stack_team_color(
  gt_object,
  col1,
  col2,
  team_col,
  font_sizes = c(12, 14),
  font_weights = c("lighter", "bold"),
  font_variants = c("small-caps"),
  color = "black"
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{col1}{The column to stack on top.}

\item{col2}{The column to merge and place below with the text team color that corresponds to \code{team_col}.}

\item{team_col}{The column of team abbreviations (cleaned with \code{clean_team_abbrs()}) that match \code{valid_team_names()} for the color of the bottom text.}

\item{font_sizes}{the font size for the top and bottom text in px. Can be vector of length 1 or 2. Defaults to c(12, 14)}

\item{font_weights}{the font weight of the top and bottom text. Can be vector of length 1 or 2. Defaults to c("lighter", "bold")}

\item{font_variants}{the font variant of the top and bottom text. Can be vector of length 1 or 2. Defaults to "small-caps"}

\item{color}{The color for the top text.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt_merge_stack_team_color()} function takes an existing \code{gt} table and merges
column 1 and column 2, stacking column 1's text on top of column 2's.
Top text is in all caps while the lower text is bigger, bolded,
and colored by the team name in another column.
This is a slightly modified version of \href{https://jthomasmock.github.io/gtExtras/reference/gt_merge_stack.html}{\code{gtExtras::gt_merge_stack()}} written by Tom Mock.
}
\examples{
\donttest{
library(gt)
library(mlbplotR)

gt_merge_example <- mlbplotR::load_mlb_teams() \%>\%
  dplyr::slice(1:5) \%>\%
  dplyr::select(team_abbr, team_location, team_mascot) \%>\%
  gt::gt() \%>\%
  gt_merge_stack_team_color(col1 = "team_location",
                            col2 = "team_mascot",
                            team_col = "team_abbr")
}
}
