% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genHarmonic.R
\name{genIntegratedharmonic}
\alias{genIntegratedharmonic}
\title{genIntegratedharmonic function}
\usage{
genIntegratedharmonic(
  df,
  t1name,
  t2name,
  base,
  num,
  sname = "bcoef",
  cname = "acoef",
  power = FALSE
)
}
\arguments{
\item{df}{a data frame containing a numeric time variable of interest}

\item{t1name}{a character string, the name of the variable in df containing the start time of the intervals}

\item{t2name}{a character string, the name of the variable in df containing the end time of the intervals}

\item{base}{the fundamental period of the signal, e.g. if it repeats over 24 hours and time is measured in hours, then put 'base = 24'; if the period is 24 hours but time is measured in days, then use 'base = 1/7'}

\item{num}{number of sin and cosine terms to compute}

\item{sname}{character string, name for cosine terms in Fourier series (not integrated)}

\item{cname}{character string, name for sine terms in Fourier series (not integrated)}

\item{power}{legacy functionality, not used here}
}
\value{
a data frame containing the start and end time vectors, together with the sin and cosine terms
}
\description{
A function to generate basis vectors for integrated Fourier series.\cr
}
\details{
If the non-integrated Fourier series is:\cr
\cr
f(t) = sum_k a_k sin(2 pi k t / P) + b_k cos(2 pi k t / P)\cr
\cr
then\cr
int_t1^t2 f(s) ds = sum_k a_k (base/(2 pi k))*(cos(2 pi k t1 / P) - cos(2 pi k t2 / P)) + \cr
                    b_k (base/(2 pi k))*(sin(2 pi k t2 / P)-sin(2 pi k t1 / P))
\cr
where P is the funcamental period, or 'base', as referred to in the function arguments
}
