% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layer_trips.R
\name{add_trips}
\alias{add_trips}
\title{Add Trips}
\usage{
add_trips(
  map,
  data = get_map_data(map),
  stroke_colour = NULL,
  stroke_width = NULL,
  width_units = c("meters", "pixels"),
  width_min_pixels = NULL,
  width_max_pixels = NULL,
  width_scale = 1,
  opacity = 0.3,
  palette = "viridis",
  trail_length = 180,
  start_time = get_m_range_start(data),
  end_time = get_m_range_end(data),
  animation_speed = 30,
  layer_id = NULL,
  legend = FALSE,
  legend_options = NULL,
  legend_format = NULL,
  update_view = TRUE,
  focus_layer = FALSE,
  digits = 6,
  ...
)
}
\arguments{
\item{map}{a mapdeck map object}

\item{data}{sf object with XYZM dimensions.}

\item{stroke_colour}{variable of data or hex colour for the stroke.}

\item{stroke_width}{width of the stroke in meters. Default 1.}

\item{width_units}{The units of the line width, one of 'meters', 'common' or 'pixels'.
When zooming in and out, meter sizes scale with the base map, and pixel sizes
remain the same on screen.}

\item{width_min_pixels}{The minimum path width in pixels.
This can be used to prevent the path from getting too thin when zoomed out.}

\item{width_max_pixels}{The maximum path width in pixels.
his prop can be used to prevent the path from getting too thick when zoomed in.}

\item{width_scale}{The path width multiplier that multiplied to all paths.}

\item{opacity}{single value in [0,1]}

\item{palette}{string or matrix. String will be one of \code{colourvalues::colour_palettes()}.
A matrix must have at least 5 rows, and 3 or 4 columns of values between [0, 255],
where the 4th column represents the alpha. You can use a named list to specify a different
palette for different colour options (where available),
 e.g. list(fill_colour = "viridis", stroke_colour = "inferno")}

\item{trail_length}{how long it takes for the trail to completely fade out
(in same units as timestamps )}

\item{start_time}{the minimum timestamp}

\item{end_time}{the maximum timestamp}

\item{animation_speed}{speed of animation}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type. Layers with the same id are likely
to conflict and not plot correctly}

\item{legend}{either a logical indiciating if the legend(s) should be displayed, or
a named list indicating which colour attributes should be included in the legend.}

\item{legend_options}{A list of options for controlling the legend.}

\item{legend_format}{A list containing functions to apply to legend values. See section legend}

\item{update_view}{logical indicating if the map should update the bounds to include this layer}

\item{focus_layer}{logical indicating if the map should update the bounds to only include this layer}

\item{digits}{number of digits for rounding coordinates}

\item{...}{\code{clear_legend} and \code{clear_view} arguments passed to 'clear_()' functions}
}
\description{
The Trips Layer takes an sf object with Z (elevation) and M (time) attributes and renders
it as animated trips
}
\details{
\code{add_trips} supports LINESTRING and MULTILINESTRING sf objects
}
\section{legend}{


The \code{legend_options} can be used to control the appearance of the legend.
This should be a named list, where the names are one of
\itemize{
  \item{css - a string of valid \code{css} for controlling the appearance of the legend}
  \item{title - a string to use for the title of the legend}
  \item{digits - number to round the legend values to}
}

If the layer allows different fill and stroke colours, you can use different options for each. See examples in \link{add_arc}.

The \code{legend_format} can be used to control the format of the values in the legend.
This should be a named list, where the names are one of
\itemize{
  \item{fill_colour}
  \item{stroke_colour}
}

depending on which type of colouring the layer supports.

The list elements must be functions to apply to the values in the legend.
}

\section{id}{


The \code{id} is returned to your R session from an interactive shiny environment
by observing layer clicks. This is useful for returning the data.frame row relating to the
cliked shape.

From within a shiny server you would typically use \code{ observeEvent({input$map_arc_click})},
where 'map' is the map_id supplied to \code{mapdeckOutput()}, and 'arc' is the layer
you are clicking on
}

\examples{
\donttest{

set_token( "MAPBOX_TOKEN")
sf <- city_trail

mapdeck(
  style = mapdeck_style("dark")
) \%>\%
 add_trips(
   data = sf
   , animation_speed = 500
   , trail_length = 500
   , stroke_colour = "#FFFFFF"
   , stroke_width = 25
)

## Multi-coloured trips
## requires a colour for each coordiante
## In this example I'm assining the elevation (z) value
## to a new column
df <- sfheaders::sf_to_df( city_trail )
df$colour <- df$z
sf <- sfheaders::sf_linestring(
  obj = df
  , x = "x"
  , y = "y"
  , z = "z"
  , m = "m"
  , keep = TRUE
  , list_column = "colour"
)

mapdeck(
  style = mapdeck_style("light")
) \%>\%
 add_trips(
   data = sf
   , animation_speed = 1000
   , trail_length = 1000
   , stroke_colour = "colour"
   , stroke_width = 50
   , legend = TRUE
)

## New York Taxi Trips
json <- jsonify::from_json(
  "https://raw.githubusercontent.com/visgl/deck.gl-data/master/examples/trips/trips.json"
)

lens <- vapply( json$segments, nrow, 1L )
mat <- do.call( rbind, json$segments )
df <- setNames( as.data.frame( mat ), c("x","y","m") )
idx <- rep( seq_along( lens ), times = lens )
df$vendor <- rep( json$vendor, times = lens )

df$z <- 0 ## z column is required in SF object
df$idx <- idx

## Using the timestamp as a colour
df$timestamp <- df$m

sf_line <- sfheaders::sf_linestring(
  obj = df
  , x = "x"
  , y = "y"
  , z = "z"
  , m = "m"
  , linestring_id = "idx"
  , keep = TRUE
  , list_column = "timestamp"
)

mapdeck(
  style = mapdeck_style("dark")
) \%>\%
  add_trips(
    data = sf_line
    , stroke_colour = "timestamp"
    , animation_speed = 1000
    , trail_length = 1000
    , palette = colourvalues::get_palette("viridis")[100:256, ]
  )


}

}
