% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{make_params}
\alias{make_params}
\title{Parameters for make-like functions}
\arguments{
\item{source}{The path to an R script which makes the \code{targets}}

\item{recipe}{A chunk of R code which makes the \code{targets}}

\item{targets}{A character vector of paths to files}

\item{dependencies}{A character vector of paths to files which the \code{targets}
depend on}

\item{packages}{A character vector of names of packages which \code{targets}
depend on}

\item{envir}{The environment in which to execute the \code{source} or \code{recipe}. By
default, execution will take place in a fresh environment whose parent is
the calling environment.}

\item{quiet}{A logical determining whether or not messages are signaled}

\item{force}{A logical determining whether or not execution of the \code{source}
or \code{recipe} will be forced (i.e. happen whether or not the targets are
out-of-date)}

\item{label}{A short label for the \code{source} or \code{recipe}, displayed in pipeline
visualisations. If \code{NULL}, the \code{basename(source)} or 'Recipe' will be used.}

\item{build}{A logical determining whether or not the pipeline/segment will be built
immediately or simply returned to the user}
}
\description{
Parameters for make-like functions
}
\keyword{internal}
