% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_print.R
\name{print.local_surrogate_explainer}
\alias{print.local_surrogate_explainer}
\title{Generic print function for local surrogate explainers}
\usage{
\method{print}{local_surrogate_explainer}(x, ...)
}
\arguments{
\item{x}{object of class local_surrogate_explainer}

\item{...}{currently ignored}
}
\description{
Generic print function for local surrogate explainers
}
\examples{
# Example based on apartments data from DALEX package.
library(DALEX)
library(randomForest)
library(localModel)
data('apartments')
mrf <- randomForest(m2.price ~., data = apartments, ntree = 50)
explainer <- explain(model = mrf,
                     data = apartments[, -1])
model_lok <- individual_surrogate_model(explainer, apartments[5, -1],
                                        size = 500, seed = 17)
plot(model_lok)
model_lok

}
