% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keys.R
\name{keys}
\alias{keys}
\title{Returns a list of indices as string, list or unique values (like \code{dimnames}).}
\usage{
keys(x, type = "character")
}
\arguments{
\item{x}{listArray object}

\item{type}{character: return the indices as string, list or unique values (default: \code{character})}
}
\value{
Returns the indices as string, list or unique indices. If \code{type} is
\describe{
\item{\code{type="character"}}{a character vector with the retranslated indices}
\item{\code{type="list"}}{as list of lists with the retranslated indices}
\item{\code{type="names"}}{as list of lists with the retranslated unique(!) indices like \code{dimnames}}
}
}
\description{
Returns a list of indices as string, list or unique values (like \code{dimnames}).
}
\examples{
l <- listArray(matrix(1:9, 3, 3))
k <- keys(l)
k
# access object in listArray
pos <- which(k=='3, 2')
l[[pos]]
#
l["test"] <- "test"
keys(l, 'c') # as keys(l)
keys(l, 'l')
keys(l, 'n')
# Note that l['test'][3] will deliver NULL since the entry does not exist
}
