% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{ga_users_list}
\alias{ga_users_list}
\title{List Users}
\usage{
ga_users_list(accountId, webPropertyId = "~all", viewId = "~all")
}
\arguments{
\item{accountId}{Account Id}

\item{webPropertyId}{Web Property Id - set to NULL to operate on account level only}

\item{viewId}{viewId - set to NULL to operate on webProperty level only}
}
\value{
A \code{data.frame} of user entity links including the linkId, email and permissions
}
\description{
Get a list of Account level user links, or if you supply the webPropertyId or viewId it will show user links at that level
}
\details{
Will list users on an account, webproperty or view level
}
\examples{

\dontrun{

library(googleAnalyticsR)
ga_auth()
ga_users_list(47480439)
ga_users_list(47480439, webPropertyId = "UA-47480439-2")
ga_users_list(47480439, webPropertyId = "UA-47480439-2", viewId = 81416156)

# use NULL to only list linkids for that level
ga_users_list(47480439, webPropertyId = NULL, viewId = NULL)
}
}
\seealso{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/accountUserLinks}{Account User Links Google Documentation}

Other User management functions: 
\code{\link{ga_users_add}()},
\code{\link{ga_users_delete}()},
\code{\link{ga_users_delete_linkid}()},
\code{\link{ga_users_update}()}
}
\concept{User management functions}
