% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsampled.R
\name{ga_unsampled_list}
\alias{ga_unsampled_list}
\title{List Unsampled Reports}
\usage{
ga_unsampled_list(accountId, webPropertyId, profileId)
}
\arguments{
\item{accountId}{Account Id}

\item{webPropertyId}{Web Property Id}

\item{profileId}{Profile Id}
}
\value{
Unsampled Reports List
}
\description{
List Unsampled Reports
}
\examples{

\dontrun{

    # get data.frame of unsampled reports you have available
    unsample_list <- ga_unsampled_list(accountId = "12345", 
                                       webPropertyId = "UA-12345-4", 
                                       profileId = "129371234")
                                       
    # loop through unsampled reports and download as a list of data.frames
    dl <- lapply(unsample_list$title, ga_unsampled_download, 
                 accountId = "12345", 
                 webPropertyId = "UA-12345-4", 
                 profileId = "129371234", 
                 downloadFile = FALSE)
                 
    # inspect first data.frame
    dl[[1]]
    
    # download unsampled report to csv file
    ga_unsampled_download("my_report_title", 
                          accountId = "12345", 
                          webPropertyId = "UA-12345-4", 
                          profileId = "129371234")

}



}
\seealso{
Other unsampled download functions: 
\code{\link{ga_unsampled}()},
\code{\link{ga_unsampled_download}()}
}
\concept{unsampled download functions}
