% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/issues.R
\name{gl_new_issue}
\alias{gl_new_issue}
\alias{gl_create_issue}
\alias{gl_edit_issue}
\alias{gl_close_issue}
\alias{gl_reopen_issue}
\alias{gl_assign_issue}
\alias{gl_unassign_issue}
\alias{gl_delete_issue}
\title{Post a new issue or edit one}
\usage{
gl_new_issue(project, title, ...)

gl_create_issue(project, title, ...)

gl_edit_issue(project, issue_id, api_version = 4, ...)

gl_close_issue(project, issue_id, ...)

gl_reopen_issue(project, issue_id, ...)

gl_assign_issue(project, issue_id, assignee_id = NULL, ...)

gl_unassign_issue(project, issue_id, ...)

gl_delete_issue(project, issue_id, ...)
}
\arguments{
\item{project}{id (preferred way) or name of the project.
Not repository name.}

\item{title}{title of the issue}

\item{...}{further parameters passed to the API call, may
contain description, assignee_id, milestone_id, labels,
state_event (for edit_issue).}

\item{issue_id}{issue id (projectwide; for API v3 only you can use global iid when force_api_v3 is \code{TRUE} although this is not recommended!)}

\item{api_version}{a switch to force deprecated GitLab API v3 behavior that allows filtering by global iid. If \code{3}
filtering happens by global iid, if false, it happens by projectwide ID. For API v4, this must be 4 (default)}

\item{assignee_id}{numeric id of users as returned in '/users/' API request}
}
\value{
Tibble with the created or remaining issues
and descriptive variables.
}
\description{
Post a new issue or edit one
}
\examples{
\dontrun{
# create an issue
new_issue_infos <- gl_create_issue(project = "<<your-project-id>>", "A simple issue")
new_issue_iid <- new_issue_infos$iid[1]
## close issue
gl_close_issue("<<your-project-id>>", new_issue_iid)
## reopen issue
gl_reopen_issue("<<your-project-id>>", new_issue_iid)
## edit its description
gl_edit_issue("<<your-project-id>>", new_issue_iid, description = "This is a test")
## assign it
gl_assign_issue("<<your-project-id>>", new_issue_iid, assignee_id = "<<user-id>>")
## unassign it
gl_unassign_issue("<<your-project-id>>", new_issue_iid)
## Delete issue as if it never existed
## (please note that you must have "Owner" role on the GitLab project)
gl_delete_issue("<<your-project-id>>", new_issue_iid)
}
}
