% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{save_model}
\alias{save_model}
\title{Save a model to the outputs directory}
\usage{
save_model(model, name, public = FALSE, overwrite = TRUE, ...)
}
\arguments{
\item{model}{A fitted model object (lm, glm, tidymodels workflow, etc.)}

\item{name}{The name for the output file (without extension)}

\item{public}{If TRUE, saves to public outputs directory (for project_sensitive type)}

\item{overwrite}{If TRUE, overwrites existing files (default: TRUE)}

\item{...}{Additional arguments passed to \code{\link[=saveRDS]{saveRDS()}}}
}
\value{
The path to the saved file (invisibly)
}
\description{
Saves a fitted model object to the configured models directory.
The directory is created lazily on first use.
}
\examples{
\donttest{
if (FALSE) {
# Fit and save a model
model <- lm(mpg ~ hp + wt, data = mtcars)
save_model(model, "mpg_regression")
}
}

}
