% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish.R
\name{publish_notebook}
\alias{publish_notebook}
\title{Publish a Quarto notebook to S3}
\usage{
publish_notebook(
  file,
  dest = NULL,
  connection = NULL,
  self_contained = TRUE,
  format = "html",
  ...
)
}
\arguments{
\item{file}{Character. Path to .qmd file.}

\item{dest}{Character or NULL. Destination path in S3 (without extension).
If NULL, derives from filename (e.g., "analysis.qmd" -> "analysis").}

\item{connection}{Character or NULL. S3 connection name, or NULL for default.}

\item{self_contained}{Logical. Whether to embed all resources. Default TRUE.
Ignored if \code{static_hosting: false} (always renders self-contained).}

\item{format}{Character. Output format. Default "html".}

\item{...}{Additional arguments passed to quarto render.}
}
\value{
Character. Public URL of the published notebook.
}
\description{
Renders a Quarto document and uploads it to S3. The notebook is rendered
to a temporary directory, uploaded, then cleaned up.
}
\details{
The URL format depends on the S3 connection's \code{static_hosting} setting:
\itemize{
\item \code{static_hosting: true} -> uploads to \code{dest/index.html}, returns \verb{dest/}
\item \code{static_hosting: false} (default) -> uploads as \code{dest.html}, returns \code{dest.html}
}
}
\examples{
\donttest{
if (FALSE) {
# With static_hosting: true -> returns /analysis/
# With static_hosting: false -> returns /analysis.html
publish_notebook("notebooks/analysis.qmd")

# Publish to specific location
publish_notebook("notebooks/analysis.qmd", dest = "reports/2024/q4")

# Publish non-self-contained (only with static_hosting: true)
publish_notebook("notebooks/analysis.qmd", self_contained = FALSE)
}
}
}
