% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/security_audit.R
\name{git_security_audit}
\alias{git_security_audit}
\title{Security audit for Framework projects}
\usage{
git_security_audit(
  config_file = NULL,
  check_git_history = TRUE,
  history_depth = "all",
  auto_fix = FALSE,
  verbose = TRUE,
  extensions = c("csv", "rds", "tsv", "txt", "dat", "xlsx", "xls", "sqlite", "db", "dta",
    "sav", "zsav", "por", "sas7bdat", "sas7bcat", "xpt", "parquet", "feather", "arrow",
    "json", "xml", "h5", "hdf5")
)
}
\arguments{
\item{config_file}{Path to configuration file (default: auto-detect settings.yml/settings.yml)}

\item{check_git_history}{Logical; if TRUE (default), check git history for leaked data files}

\item{history_depth}{Character or numeric. "all" for full history, "shallow" for recent 100 commits,
or numeric for specific commit count (default: "all")}

\item{auto_fix}{Logical; if TRUE, automatically update .gitignore (default: FALSE)}

\item{verbose}{Logical; if TRUE (default), show progress messages}

\item{extensions}{Character vector of data file extensions to detect (default: common data formats)}
}
\value{
A structured list containing:
\describe{
\item{summary}{Data frame with check names, status (pass/warning/fail), and counts}
\item{findings}{List of data frames with detailed findings for each check}
\item{recommendations}{Character vector of actionable recommendations}
\item{audit_metadata}{List with audit timestamp, Framework version, and config info}
}
}
\description{
Performs a comprehensive security audit of data files in Framework projects,
checking for unignored data files, git history leaks, and orphaned data files
outside configured directories.
}
\details{
The security audit performs the following checks:
\itemize{
\item \strong{gitignore_coverage}: Verifies all private data files are in .gitignore
\item \strong{git_history}: Scans git history for accidentally committed data files
\item \strong{orphaned_files}: Finds data files outside configured directories
\item \strong{private_data_exposure}: Checks if private data is tracked by git
}

Status levels:
\itemize{
\item \strong{pass}: No issues found
\item \strong{warning}: Potential issues that should be reviewed
\item \strong{fail}: Critical security issues requiring immediate action
}
}
\examples{
\donttest{
if (FALSE) {
# Basic audit (report only)
audit <- git_security_audit()
print(audit$summary)
View(audit$findings$orphaned_files)

# Quick scan without git history
audit <- git_security_audit(check_git_history = FALSE)

# Verbose with limited git history
audit <- git_security_audit(history_depth = 100, verbose = TRUE)

# Auto-fix mode (updates .gitignore)
audit <- git_security_audit(auto_fix = TRUE)
}
}

}
