% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fp_set_zebra_style.R
\name{fp_set_zebra_style}
\alias{fp_set_zebra_style}
\title{Decorate the plot with a zebra pattern}
\usage{
fp_set_zebra_style(x, ..., ignore_subheaders = FALSE)
}
\arguments{
\item{x}{The forestplot object}

\item{...}{The styles for each row}

\item{ignore_subheaders}{The zebra will automatically restart at sub-headers,
i.e. when there is a \emph{summary} row that doesn't have any values.}
}
\value{
The forestplot object with the zebra style
}
\description{
Decorate the plot with a zebra pattern
}
\examples{
base_data <- tibble::tibble(mean  = c(0.578, 0.165, 0.246, 0.700, 0.348, 0.139, 1.017),
                            lower = c(0.372, 0.018, 0.072, 0.333, 0.083, 0.016, 0.365),
                            upper = c(0.898, 1.517, 0.833, 1.474, 1.455, 1.209, 2.831),
                            study = c("Auckland", "Block", "Doran", "Gamsu",
                                      "Morrison", "Papageorgiou", "Tauesch"),
                            deaths_steroid = c("36", "1", "4", "14", "3", "1", "8"),
                            deaths_placebo = c("60", "5", "11", "20", "7", "7", "10"),
                            OR = c("0.58", "0.16", "0.25", "0.70", "0.35", "0.14", "1.02"))

base_data |>
  forestplot(labeltext = c(study, deaths_steroid, deaths_placebo, OR),
             clip = c(0.1, 2.5),
             xlog = TRUE) |>
  fp_add_header(study = c("", "Study"),
                deaths_steroid = c("Deaths", "(steroid)"),
                deaths_placebo = c("Deaths", "(placebo)"),
                OR = c("", "OR")) |>
  fp_set_style(box = "royalblue",
               line = "darkblue",
               summary = gpar(fill = "royalblue", clr = "black")) |>
  fp_set_zebra_style("#EFEFEF")
}
\seealso{
Other graph modifiers: 
\code{\link{fp_add_lines}()},
\code{\link{fp_decorate_graph}()},
\code{\link{fp_insert_row}()},
\code{\link{fp_set_style}()}

Other forestplot functions: 
\code{\link{forestplot}()},
\code{\link{fpColors}()},
\code{\link{fpDrawNormalCI}()},
\code{\link{fpLegend}()},
\code{\link{fpShapesGp}()},
\code{\link{fp_add_lines}()},
\code{\link{fp_decorate_graph}()},
\code{\link{fp_insert_row}()},
\code{\link{fp_set_style}()}
}
\concept{forestplot functions}
\concept{graph modifiers}
