% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_toXML}
\alias{fxml_toXML}
\title{Converting between XML and dataframes}
\usage{
fxml_toXML(
  df,
  filename = NULL,
  element.tag = "record",
  indent = "\\t",
  line.break = "\\n",
  return.xml = FALSE
)
}
\arguments{
\item{df}{The dataframe to be converted (also works with tibbles and the like)}

\item{filename}{Name of the file to which the XML will be saved; default is \code{NULL} meaning no file is produced}

\item{element.tag}{The tag name of the XML element that will carry the data (see example)}

\item{indent}{Character(s) used for indentation to make the XML prettier; tabulator (\code{"\\t"}) by default ("" will lead to no indentation)}

\item{line.break}{Character(s) that is written at the end of each line of the XML (line break \code{"\\n"} by default)}

\item{return.xml}{If \code{TRUE}, the XML will be returned by the function; so you can decide if you want the function write a file, or just return the XML code, or both.}
}
\value{
If \code{return.xml == TRUE} the XML code is returned. If \code{filename} is not \code{NULL} then the XML is (additionally) written to the specified file.
}
\description{
Converts a dataframe to XML.
}
\examples{
mydata<-data.frame(list(var1 = c("a", "b", "c"), var2 = c(1,2,3)))
fxml_toXML(mydata, return.xml = TRUE)

}
\seealso{
\code{\link{fxml_toDataFrame}}
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
