% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.var.R
\name{ds.var}
\alias{ds.var}
\title{Computes server-side vector variance}
\usage{
ds.var(x = NULL, type = "split", checks = FALSE, datasources = NULL)
}
\arguments{
\item{x}{a character specifying the name of a numerical vector.}

\item{type}{a character string that represents the type of analysis to carry out.
This can be set as \code{'combine'}, \code{'combined'}, \code{'combines'},
\code{'split'}, \code{'splits'}, \code{'s'},
\code{'both'} or \code{'b'}. 
For more information see \strong{Details}.}

\item{checks}{logical. If TRUE  optional checks of model
components will be undertaken. Default is FALSE to save time. 
It is suggested that checks
should only be undertaken once the function call has failed.}

\item{datasources}{a list of \code{\link[DSI]{DSConnection-class}} 
objects obtained after login. If the \code{datasources} argument is not specified
the default set of connections will be used: see \code{\link[DSI]{datashield.connections_default}}.}
}
\value{
\code{ds.var} returns to the client-side a list including:\cr

 \code{Variance.by.Study}: estimated variance, \code{Nmissing}
(number of missing observations), \code{Nvalid} (number of valid observations) and
\code{Ntotal} (sum of missing and valid observations) 
separately for each study (if \code{type = split} or \code{type = both}).\cr
\code{Global.Variance}: estimated variance, \code{Nmissing}, \code{Nvalid} and \code{Ntotal} 
across all studies combined (if \code{type = combine} or \code{type = both}). \cr
\code{Nstudies}: number of studies being analysed. \cr
\code{ValidityMessage}: indicates if the analysis was possible. \cr
}
\description{
Computes the variance of a given server-side vector.
}
\details{
This function is similar to the R function \code{var}.

The function can carry out 3 types of analysis depending on
the argument \code{type}:\cr
(1) If \code{type} is set to \code{'combine'}, \code{'combined'}, 
\code{'combines'} or \code{'c'}, a global variance is calculated.\cr
(2) If \code{type} is set to \code{'split'}, \code{'splits'} or \code{'s'},
 the variance is calculated separately for each study. \cr
(3) If \code{type} is set to \code{'both'} or \code{'b'}, 
both sets of outputs are produced.

Server function called: \code{varDS}
}
\examples{
\dontrun{

 ## Version 6, for version 5 see the Wiki
  
  # connecting to the Opal servers

  require('DSI')
  require('DSOpal')
  require('dsBaseClient')

  builder <- DSI::newDSLoginBuilder()
  builder$append(server = "study1", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM1", driver = "OpalDriver")
  builder$append(server = "study2", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM2", driver = "OpalDriver")
  builder$append(server = "study3",
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM3", driver = "OpalDriver")
  logindata <- builder$build()
  
  connections <- DSI::datashield.login(logins = logindata, assign = TRUE, symbol = "D") 
  
  #Calculate the variance of a vector in the server-side
  
  ds.var(x = "D$LAB_TSC",
          type = "split",
          checks = FALSE,
          datasources = connections)
             
  # clear the Datashield R sessions and logout
  datashield.logout(connections)
}

}
\author{
DataSHIELD Development Team
}
