% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFuncs.R
\name{checkRanges}
\alias{checkRanges}
\title{Checking if the value of a numeric or integer variable (of length 1) is located within a certain range.}
\usage{
checkRanges(listObjects, listRanges)
}
\arguments{
\item{listObjects}{List of numeric or integer vectors, of each of length 1. It contains the list of variables of which one wants to test its value against a vector of valid values. This argument is obligatory.}

\item{listRanges}{List of character vectors, each character vector should be of length 2 or 4, while the 'listRanges' list should be of the same length as the 'listObjects' argument. It contains the values against which one wants to test the 'listObjects' argument. This argument is obligatory.}
}
\value{
No value is returned if all vectors of the 'listObjects' argument is contained within the corresponding ranges of the 'listRanges' argument. An error message is thrown when this is not the case for at least one of the elements of the 'listObjects' argument. Note that each element of the 'listRange' argument should be of the following structure. The first element of the character vector, as well as the third element if the character vector is of length 4, should either be '>', '>=', '<' or '<='. In case that the length of the character vector is 4, the first and the third element should be opposite directions (some form of '>' combined with some form of '<'). The second and fourth element should be a numeric value coerced to a character. If the character vector is of length 2 (4), then the range is either bounded from below or (and) above.
}
\description{
Checking if the value of a numeric or integer variable (of length 1) is located within a certain range.
}
\examples{
someValue <- 2
checkRanges(list(someValue), list(c('<', 3)))

\donttest{someValue <- '2'
checkRanges(list(someValue), list(c('<', 3)))
checkRanges(list(someValue), list(c(1.5, 3)))}

someValue <- 6
someOtherValue <- 5
checkRanges(list(someValue, someOtherValue), list(c('>=', 2.5), c('>=', 2.5, '<=', 5)))
\donttest{checkRanges(list(someValue, someOtherValue), list(c('>=', 2.5), c('>=', 2.5, '<', 5)))
checkRanges(list(someValue, someOtherValue), list(c('>=', 2.5, '<=', 5), c('>=', 2.5, '<', 5)))}
}
