% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.rank.R
\name{spatial.rank}
\alias{spatial.rank}
\title{Spatial Rank}
\usage{
spatial.rank(x, data)
}
\arguments{
\item{x}{A numeric p-variate vector whose spatial rank is to be calculated.}

\item{data}{A matrix or a data.frame with each row as a p-variate observation.}
}
\value{
The spatial rank of \code{x} with respect to \code{data}.
}
\description{
Used to compute the \code{Spatial Rank} of a p-variate observation with respect to a p-variate data cloud.
}
\examples{
u<-matrix(rnorm(90,0,1),ncol=3)
u0<-runif(3,0,1)
spatial.rank(u0,u)
}
\author{
Somedip Karmakar <somedip@yahoo.co.in>

Omker Mahalanobish <omker.scorpio@gmail.com>
}

