% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbWebForms.R
\name{dbTableInfo}
\alias{dbTableInfo}
\title{Query INFORMATION_SCHEMA or equivalent SQL meta data to obtain column names and types for a table.}
\usage{
dbTableInfo(
  con = NULL,
  sql = c("MariaDB", "Microsoft SQL Server", "MySQL", "PostgreSQL", "SQLite"),
  table_catalog = NULL,
  table_schema = NULL,
  table_name
)
}
\arguments{
\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}

\item{sql}{A string, the type of SQL database con is connected to; must be one of c("MariaDB", "Microsoft SQL Server", "MySQL", "PostgreSQL", "SQLite").}

\item{table_catalog}{A string, the catalog (usually a database name) name of the SQL table to return column meta data for. Not used if sql = "SQLite".}

\item{table_schema}{A string, the schema name of the SQL table to return column meta data for.}

\item{table_name}{A string, the name of the SQL table to return column meta data for.}
}
\value{
A data.table, two columns, "column_name" has the names of the columns in the specified SQL table and "data_type" has the data types for each column.
If con is NULL, returns the SQL string for querying the meta data but does not execute the statement.
}
\description{
Query INFORMATION_SCHEMA or equivalent SQL meta data to obtain column names and types for a table.
}
\examples{
dbTableInfo(
con = NULL,
sql = "PostgreSQL",
table_catalog = "db1",
table_schema = "public",
table_name = "table1"
)
}
