% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaleweight.R
\name{scaleweight}
\alias{scaleweight}
\title{Scales the content of a column}
\usage{
scaleweight(DAT_df, var = "all", val = 5)
}
\arguments{
\item{DAT_df}{a data.frame}

\item{var}{index or name of the column that should be used
as the group variable, OR "all"}

\item{val}{index or name of the column that should be
scaled (has to be numeric)}
}
\value{
the same data.frame, with the scaled values in the specified column
}
\description{
Requires a data.frame with one variable and one value column.
}
\examples{
data("Inscr_Bithynia")
DAT_df <- Inscr_Bithynia[, c("ID", "Location", "DAT_min", "DAT_max")]
DAT_df_steps <- datsteps(DAT_df, stepsize = 25)
DAT_df_scaled <- scaleweight(DAT_df_steps, var = 2, val = 5)
}
