% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_waterdata_parameter_codes.R
\name{read_waterdata_parameter_codes}
\alias{read_waterdata_parameter_codes}
\title{Get USGS Parameter Code Information}
\usage{
read_waterdata_parameter_codes(
  parameter_code = NA_character_,
  parameter_name = NA_character_,
  unit_of_measure = NA_character_,
  parameter_group_code = NA_character_,
  parameter_description = NA_character_,
  medium = NA_character_,
  statistical_basis = NA_character_,
  weight_basis = NA_character_,
  sample_fraction = NA_character_,
  temperature_basis = NA_character_,
  epa_equivalence = NA_character_,
  properties = NA_character_,
  limit = NA
)
}
\arguments{
\item{parameter_code}{Parameter code.}

\item{parameter_name}{Parameter short name.}

\item{unit_of_measure}{Parameter reporting units defined to cooperate with descriptions by USEPA.}

\item{parameter_group_code}{Categorical groupings of parameters by water-quality data type for display and report ordering}

\item{parameter_description}{Parameter description.}

\item{medium}{Parameter medium.}

\item{statistical_basis}{Parameter statistical basis.}

\item{weight_basis}{Parameter weight basis.}

\item{sample_fraction}{Parameter fraction.}

\item{temperature_basis}{Parameter temperature basis.}

\item{epa_equivalence}{Indicates the relationship of the USGS parameter code to the EPA code.}

\item{properties}{A vector of requested columns to be returned from the query.
Available options are:
geometry, parameter_code_id, parameter_name, unit_of_measure, parameter_group_code, parameter_description, medium, statistical_basis, time_basis, weight_basis, particle_size_basis, sample_fraction, temperature_basis, epa_equivalence.
The default (\code{NA}) will return all columns of the data.}

\item{limit}{The optional limit parameter is used to control the subset of the
selected features that should be returned in each page. The maximum allowable
limit is 50000. It may be beneficial to set this number lower if your internet
connection is spotty. The default (\code{NA}) will set the limit to the maximum
allowable limit for the service.}
}
\description{
Parameter codes are 5-digit codes and associated descriptions used to identify the constituent measured and the units of measure. Some parameter code definitions include information about the sampling matrix, fraction, and methods used to measure the constituent. Some parameters are fixed-value (fxd) numeric codes having textual meaning (for example: parameter code 00041 is a weather code parameter, code of 60 means rain), but more commonly represent a numeric value for chemical, physical, or biological data.
}
\examples{
\dontshow{if (is_dataRetrieval_user()) withAutoprint(\{ # examplesIf}

\donttest{
pcode <- "00060"
pcode_info <- read_waterdata_parameter_codes(parameter_code = pcode)

pcodes <- read_waterdata_parameter_codes(parameter_code = c("00660", "00060"))

# equivalent to read_waterdata_metadata("parameter-codes")
all_pcodes <- read_waterdata_parameter_codes() 

total_nutrients <- read_waterdata_parameter_codes(parameter_group_code = "NUT",
                                           sample_fraction = "Total")
                                           
group_of_nutrients <- read_waterdata_parameter_codes(parameter_group_code = "NUT",
                                                    unit_of_measure = c("mg/l",
                                                    "mg/l as N", "mg/l NO3",
                                                    "mg/l asNO2"))

}
\dontshow{\}) # examplesIf}
}
