% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_methods.R
\name{SetFormat}
\alias{SetFormat}
\title{Set a formatter function on a specific node}
\usage{
SetFormat(node, name, formatFun)
}
\arguments{
\item{node}{The node on which to set the formatter}

\item{name}{The attribute name for which to set the formatter}

\item{formatFun}{The formatter, i.e. a function taking a value as an input, and formatting
returning the formatted value}
}
\description{
Formatter functions set on a Node act as a default formatter when printing and using
the \code{\link{Get}} method. The formatter is inherited, meaning that whenever
\code{Get} fetches an attribute from a \code{Node}, it checks on the \code{Node} or
on any of its ancestors whether a formatter is set.
}
\examples{
data(acme)
acme$Set(id = 1:(acme$totalCount))
SetFormat(acme, "id", function(x) FormatPercent(x, digits = 0))
SetFormat(Climb(acme, "IT"), "id", FormatFixedDecimal)
print(acme, "id")
# Calling Get with an explicit formatter will overwrite the default set on the Node:
print(acme, id = acme$Get("id", format = function(x) paste0("id:", x)))

# Or, to avoid formatters, even though you set them on a Node:
print(acme, id = acme$Get("id", format = identity))


}
\seealso{
Get

print.Node
}
