% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csdm_methods.R
\name{print.summary.csdm_fit}
\alias{print.summary.csdm_fit}
\title{Print method for csdm summary objects}
\usage{
\method{print}{summary.csdm_fit}(x, digits = 4, ...)
}
\arguments{
\item{x}{A \code{summary.csdm_fit} object.}

\item{digits}{Number of digits to print.}

\item{...}{Further arguments passed to methods.}
}
\value{
Invisibly returns \code{x}.
}
\description{
Formats and prints a \code{summary.csdm_fit} object. Output adapts to model
type and includes coefficient tables, selected goodness-of-fit diagnostics,
and compact model metadata.
}
\details{
The printout includes classic Pesaran CD diagnostics from the summary object.
For a full CD diagnostic panel (CD, CDw, CDw+, CD*), use \code{\link[=cd_test]{cd_test()}} on the
fitted model.
}
\seealso{
\code{\link[=summary.csdm_fit]{summary.csdm_fit()}}, \code{\link[=cd_test]{cd_test()}}
}
