% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantileSE.R
\name{quantileSE}
\alias{quantileSE}
\title{Find standard error for survival quantile}
\usage{
quantileSE(timevar, censor, q = 0.5, B = 1000, alpha = 0.05,
  seed = 1991, plots = FALSE)
}
\arguments{
\item{timevar}{Vector of observed survival times.}

\item{censor}{Vector of censoring indicators (1 = uncensored, 0 = censored).}

\item{q}{Quantile of interest (Default is median).}

\item{B}{Number of bootstrap samples.}

\item{alpha}{Significance level for confidence interval of quantile.}

\item{seed}{Seed number (for reproducibility).}

\item{plots}{Logical. TRUE to show Kaplan-Meier plot}
}
\value{
Returns quantile estimate, bootstrapped standard error, and (1 - alpha / 2) * 100% confidence interval for quantile estimate.
}
\description{
Find standard error for survival quantile
}
\examples{
#Reference: Survival Analysis Techniques for Censored and Truncated Data.
#Klein and Moeschberger (1997) Springer.
#Data: Chapter 7.6 Example 7.9 (p. 211)
library(controlTest)
t1 <- c(1, 63, 105, 129, 182, 216, 250, 262, 301, 301,
       342, 354, 356, 358, 380, 383, 383, 338, 394, 408, 460, 489,
       499, 523, 524, 535, 562, 569, 675, 676, 748, 778, 786, 797,
       955, 968, 1000, 1245, 1271, 1420, 1551, 1694, 2363, 2754, 2950)
c1 <- c(rep(1, 43), 0, 0)
quantileSE(timevar = t1, censor = c1, q = 0.5, B = 500)
}
