% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readability_indices.R
\name{readability_multiple}
\alias{readability_multiple}
\title{Calculate readability indices for multiple texts}
\usage{
readability_multiple(texts, detailed = FALSE, text_id = NULL)
}
\arguments{
\item{texts}{Character vector containing texts to analyze}

\item{detailed}{Logical, if TRUE returns detailed statistics along with indices}

\item{text_id}{Optional character vector with identifiers for each text}
}
\value{
A tibble with one row per text, including text_id if provided
}
\description{
Vectorized version that calculates readability indices for multiple texts.
}
\examples{
\dontrun{
texts <- c("First text here.", "Second text is longer and more complex.")
ids <- c("doc1", "doc2")
readability_multiple(texts, text_id = ids, detailed = TRUE)
}

}
