% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.comparison.R
\name{match.layers.x.runs}
\alias{match.layers.x.runs}
\title{Match layers up across independent conStruct runs}
\usage{
match.layers.x.runs(admix.mat1, admix.mat2, admix.mat1.order = NULL)
}
\arguments{
\item{admix.mat1}{A \code{matrix} of estimated admixture proportions
from the original \code{conStruct} analysis, with one row 
per sample and one column per layer.}

\item{admix.mat2}{A \code{matrix} of estimated admixture proportions
from a second \code{conStruct} analysis, with one row per 
sample and one column per layer, for which the 
layer order is desired. Must have equal or greater number 
of layers to \code{admix.mat1}.}

\item{admix.mat1.order}{An optional \code{vector} giving the
order in which the layers of \code{admix.mat1} are read.}
}
\value{
This function returns a \code{vector} giving the ordering 
			of the layers in \code{admix.mat2} that maximizes 
			similarity between \code{admix.mat1} and re-ordered 
		\code{admix.mat2}.
}
\description{
\code{match.layers.x.runs}
}
\details{
This function takes the results of two independent
\code{conStruct} analyses and compares them to identify 
which layers in a new analysis correspond most closely 
to the layers from an original analysis.

This function compares admixture proportions in layers across 
		independent \code{conStruct} runs, and compares between them to 
			identify the layers in \code{admix.mat2} that correspond most 
		closely to those in \code{admix.mat1}. It then returns a vector 
			giving an ordering of \code{admix.mat2} that matches up the order
			of the layers that correspond to each other.  This can be useful 
			for:
		\enumerate{
			\item Dealing with "label switching" across independent runs 
				with the same number of layers; 
			\item Plotting results from independent runs with different 
				numbers of layers using consistent colors
					(e.g., the "blue" layer shows up as blue even as 
				\code{K} increases); 
				\item Examining results for multimodality (i.e., multiple 
				distinct solutions with qualitatively different patterns
				of membership across layers).
			}
			The \code{admix.mat1.order} argument can be useful when running 
			this function to sync up plotting colors/order across the output 
			of more than two \code{conStruct} runs.
}
\examples{
\dontshow{
	admix.props1 <- matrix(c(0.09,0.00,0.50,0.51,0.10,0.05,0.02,0.01,0.80,0.00,0.22,0.74,0.92,0.20,0.47,0.00,0.78,0.30,0.33,0.45,0.00,0.00,0.64,0.90,0.00,0.00,0.00,0.01,0.02,0.00,0.00,0.09,0.00,0.55,0.00,0.00,0.00,0.09,0.02,0.00,0.00,0.01,0.00,0.20,0.00,0.06,0.05,0.08,0.04,0.01,0.00,0.06,0.17,0.14,0.03,0.00,0.00,0.18,0.08,0.00,1.00,1.00,0.99,0.98,0.98,1.00,0.74,0.98,0.43,1.00,0.91,1.00,0.41,0.47,0.90,0.95,0.96,0.99,0.00,1.00,0.72,0.20,0.00,0.77,0.52,1.00,0.15,0.53,0.53,0.53,1.00,1.00,0.18,0.02,1.00,0.00,0.00,0.00,0.00,0.02,0.00,0.17,0.02,0.01,0.00),ncol=3)
	admix.props2 <- matrix(c(0.36,0.35,0.42,0.38,0.35,0.35,0.36,0.35,0.48,0.36,0.39,0.39,0.40,0.36,0.36,0.35,0.40,0.46,0.45,0.38,0.34,0.35,0.47,0.40,0.35,1.00,1.00,0.99,0.99,0.98,1.00,0.84,0.99,0.63,1.00,0.32,0.35,0.24,0.24,0.33,0.34,0.33,0.35,0.15,0.32,0.32,0.10,0.30,0.33,0.27,0.36,0.13,0.26,0.27,0.22,0.36,0.35,0.14,0.11,0.35,0.00,0.00,0.00,0.01,0.01,0.00,0.07,0.00,0.18,0.00,0.32,0.30,0.34,0.38,0.31,0.30,0.31,0.30,0.36,0.32,0.30,0.51,0.30,0.31,0.37,0.30,0.47,0.29,0.28,0.40,0.30,0.31,0.39,0.49,0.30,0.00,0.00,0.00,0.00,0.01,0.00,0.09,0.01,0.19,0.00),ncol=3)
}
# compare the estimated admixture proportions from 
# two different conStruct runs to determine which 
# layers in one run correspond to those in the other
match.layers.x.runs(admix.props1,admix.props2)

}
