% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver_optim.R
\name{nelder_mead}
\alias{nelder_mead}
\title{Nelder-Mead Solver (Derivative-Free)}
\usage{
nelder_mead(max_iter = 500L, tol = 1e-08)
}
\arguments{
\item{max_iter}{Maximum number of iterations}

\item{tol}{Convergence tolerance}
}
\value{
A solver function
}
\description{
Creates a solver using the Nelder-Mead simplex method via \code{optim()}.
This is a derivative-free method useful when gradients are unavailable
or unreliable.
}
\details{
Nelder-Mead doesn't use gradient information, making it robust but
potentially slower. It's useful as a fallback when gradient-based
methods fail, or for problems with non-smooth likelihoods.
}
\examples{
\donttest{
set.seed(42)
x <- rnorm(50, 5, 2)
problem <- mle_problem(
  loglike = function(theta) sum(dnorm(x, theta[1], theta[2], log = TRUE)),
  constraint = mle_constraint(support = function(theta) theta[2] > 0,
                              project = function(theta) c(theta[1], max(theta[2], 1e-8)))
)
# Use when gradients are problematic
result <- nelder_mead()(problem, c(4, 1.5))

# Race against gradient methods
strategy <- gradient_ascent() \%|\% nelder_mead()
}

}
