% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-geom.R
\name{ccText}
\alias{ccText}
\title{Draw text in a cell}
\usage{
ccText(
  x = NULL,
  y = NULL,
  labels,
  direction = NULL,
  facing = c("inside", "outside", "reverse.clockwise", "clockwise", "downward",
    "bending", "bending.inside", "bending.outside"),
  niceFacing = FALSE,
  adj = par("adj"),
  cex = 1,
  col = par("col"),
  font = par("font"),
  ...
)
}
\arguments{
\item{x}{Data points on x-axis}

\item{y}{Data points on y-axis}

\item{labels}{Labels for each points}

\item{direction}{deprecated, use \code{facing} instead.}

\item{facing}{Facing of text. Please refer to vignette for different settings}

\item{niceFacing}{Should the facing of text be adjusted to fit human eyes?}

\item{adj}{offset for text. By default the text position adjustment is either horizontal or vertical in the canvas coordinate system. The "circular horizontal" offset can be set as a value in degree unit and the value should be wrapped by \code{\link[circlize]{degree}}.}

\item{cex}{Font size}

\item{col}{Font color}

\item{font}{Font style}

\item{...}{Pass to \code{\link[graphics]{text}}}
}
\value{
Object \linkS4class{ccCellGeom}
}
\description{
Object \linkS4class{ccCellGeom} will call the function \link[circlize:circos.text]{circlize::circos.text} while drawing.
}
\examples{
library(circlizePlus)
n <- 1000
df <- data.frame(
  sectors = sample(letters[1:8], n, replace = TRUE),
  x = rnorm(n), y = runif(n)
)
par1 <- ccPar("track.height" = 0.1)
cc <- ccPlot(sectors = df$sectors, x = df$x) + par1
track1 <- ccTrack(
  sectors = df$sectors, y = df$y,
  panel.fun = function(x, y) {
    circos.text(
      CELL_META$xcenter,
      CELL_META$cell.ylim[2] + mm_y(5),
      CELL_META$sector.index
    )
    circos.axis(labels.cex = 0.6)
  }
)
cell1 <- ccCell(sector.index = "a") + ccText(-1, 0.5, "text")
track1 <- track1 + cell1
cc <- cc + track1
cc
}
