% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-geom.R
\name{ccGenomicRect}
\alias{ccGenomicRect}
\title{Draw rectangle for genomic data visualization}
\usage{
ccGenomicRect(
  region = NULL,
  value = NULL,
  ytop = NULL,
  ybottom = NULL,
  ytop.column = NULL,
  ybottom.column = NULL,
  posTransform = NULL,
  col = NA,
  border = "black",
  lty = par("lty"),
  ...
)
}
\arguments{
\item{region}{A data frame contains 2 column which correspond to start positions and end positions.
}

\item{value}{A data frame contains values and other information.
}

\item{ytop}{A vector or a single value indicating top position of rectangles.
}

\item{ybottom}{A vector or a single value indicating bottom position of rectangles.
}

\item{ytop.column}{If \code{ytop} is in \code{value}, the index of the column.
}

\item{ybottom.column}{If \code{ybottom} is in \code{value}, the index of the column.
}

\item{posTransform}{Self-defined function to transform genomic positions, see \code{\link[circlize]{posTransform.default}} for explaination.
}

\item{col}{The length of \code{col} can be either one or number of rows of \code{region}. Pass to \code{\link[circlize]{circos.rect}}.
}

\item{border}{Settings are similar as \code{col}. Pass to \code{\link[circlize]{circos.rect}}.
}

\item{lty}{Settings are similar as \code{col}. Pass to \code{\link[circlize]{circos.rect}}.
}

\item{...}{Mysterious parameters.
}
}
\value{
Object \linkS4class{ccGenomicCellGeom}
}
\description{
Object \linkS4class{ccGenomicCellGeom} will call the function \link[circlize:circos.genomicRect]{circlize::circos.genomicRect} while drawing.
}
\examples{
library(circlizePlus)
par1 <- ccPar("track.height" = 0.1, cell.padding = c(0, 0, 0, 0))
cc <- ccPlot(initMode = "initializeWithIdeogram", plotType = NULL)
bed1 <- generateRandomBed(nr = 100)
bed2 <- generateRandomBed(nr = 100)
bed_list <- list(bed1, bed2)
f <- colorRamp2(breaks = c(-1, 0, 1), colors = c("green", "black", "red"))
track1 <- ccGenomicTrack(data = bed_list, stack = TRUE)
all_chr <- c("chr1", "chr2", "chr3", "chr4", "chr5", "chr6", "chr7", "chr8",
"chr9", "chr10", "chr11", "chr12", "chr13", "chr14", "chr15", "chr16",
"chr17", "chr18", "chr19", "chr20", "chr21", "chr22", "chrX", "chrY")
rect1 <- ccGenomicRect(col = 1, border = NA)
cells1 <- ccCells(sector.indexes = all_chr) + rect1
cc + par1 + (track1 + cells1)
}
