% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.spec.object.R
\name{create.spec.object}
\alias{create.spec.object}
\title{create.spec.object}
\usage{
create.spec.object(
  wave,
  wl = 512,
  ovl = 450,
  freq_range = c(0, 20000),
  plot_it = TRUE,
  thr_low = 1.5,
  thr_high = 3,
  sum_one = FALSE,
  method = "sd"
)
}
\arguments{
\item{wave}{wave object, e.g., from `load.wave` or `readWave`.}

\item{wl}{numeric, window length in samples. Default is `512`.}

\item{ovl}{numeric, overlap in samples. Default is `450`.}

\item{freq_range}{numeric vector of length 2, the frequency range in Hz to
return.}

\item{plot_it}{logical, if `TRUE`, returns three-panel plot of wave form,
envelope and spectrogram to current plotting window. Default is `FALSE`.}

\item{thr_low}{numeric, the lower range (see `method`). Pixels with lower
values are set to 0 for noise reduction.}

\item{thr_high}{numeric, the upper range (see `method`). Pixels with higher
values are set to `thr_high`.}

\item{sum_one}{logical, if `TRUE` pixels are divided by the sum of all
pixels, such that they sum to one.}

\item{method}{character, either `sd` or `max`. If `sd`, pixels are
standardised. If `max`, pixels are normalised.}
}
\value{
Returns a numeric matrix with the spectrogram values.
}
\description{
Creates a tailored spectrogram (matrix) for spectrographic
cross correlation.
}
\examples{
require(callsync)
require(seewave)
require(tuneR)
path_git = 'https://raw.githubusercontent.com'
path_repo = '/simeonqs/callsync/master/tests/testthat/files'
file_1 = '/wave_1.wav'
url_1 = paste0(path_git, path_repo, file_1)
local_file_1 = paste(tempdir(), file_1, sep = '/')
if(!file.exists(local_file_1))
  download.file(url_1, destfile = local_file_1, mode = 'wb',)
wave = readWave(local_file_1)
result = create.spec.object(wave, plot_it = FALSE)

}
