% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_pegel_online.R
\name{pegel_online_measurements_plot}
\alias{pegel_online_measurements_plot}
\title{Get Pegel-Online measurements plot}
\usage{
pegel_online_measurements_plot(
  station,
  timeseries,
  start = NULL,
  end = NULL,
  safe = TRUE,
  refresh = FALSE
)
}
\arguments{
\item{station}{Station UUID, name, or number.}

\item{timeseries}{Timeseries shortname.}

\item{start}{Start timestamp in ISO 8601.}

\item{end}{End timestamp in ISO 8601.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble with raw PNG bytes.
}
\description{
Get Pegel-Online measurements plot
}
\details{
Returns a PNG plot for the measurements endpoint. Official docs:
https://pegel-online.api.bund.dev.
}
\examples{
\dontrun{
stations <- pegel_online_stations(params = list(limit = 1))
pegel_online_measurements_plot(stations$uuid[[1]], "W",
  start = "2024-01-01T00:00:00Z",
  end = "2024-01-02T00:00:00Z"
)
}

}
\seealso{
\code{\link[=pegel_online_measurements]{pegel_online_measurements()}} for numeric values.
}
