% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBS.R, R/methods.R
\name{NBS}
\alias{NBS}
\alias{summary.NBS}
\alias{nobs.NBS}
\alias{terms.NBS}
\alias{formula.NBS}
\alias{labels.NBS}
\alias{case.names.NBS}
\alias{variable.names.NBS}
\alias{df.residual.NBS}
\alias{nregions.NBS}
\title{Network-based statistic for brain MRI data}
\usage{
NBS(
  A,
  covars,
  contrasts,
  con.type = c("t", "f"),
  X = NULL,
  con.name = NULL,
  p.init = 0.001,
  perm.method = c("freedmanLane", "terBraak", "smith", "draperStoneman", "manly",
    "stillWhite"),
  part.method = c("beckmann", "guttman", "ridgway"),
  N = 1000,
  perms = NULL,
  symm.by = c("max", "min", "avg"),
  alternative = c("two.sided", "less", "greater"),
  long = FALSE,
  ...
)

\method{summary}{NBS}(
  object,
  contrast = NULL,
  digits = max(3L, getOption("digits") - 2L),
  ...
)

\method{nobs}{NBS}(object, ...)

\method{terms}{NBS}(x, ...)

\method{formula}{NBS}(x, ...)

\method{labels}{NBS}(object, ...)

\method{case.names}{NBS}(object, ...)

\method{variable.names}{NBS}(object, ...)

\method{df.residual}{NBS}(object, ...)

\method{nregions}{NBS}(object)
}
\arguments{
\item{A}{Three-dimensional array of all subjects' connectivity matrices}

\item{covars}{A \code{data.table} of covariates}

\item{contrasts}{Numeric matrix (for T statistics) or list of matrices (for F
statistics) specifying the contrast(s) of interest; if only one contrast is
desired, you can supply a vector (for T statistics)}

\item{con.type}{Character string; either \code{'t'} or \code{'f'} (for t or
F-statistics). Default: \code{'t'}}

\item{X}{Numeric matrix, if you wish to supply your own design matrix.
Ignored if \code{outcome != measure}.}

\item{con.name}{Character vector of the contrast name(s); if \code{contrasts}
has row/list names, those will be used for reporting results}

\item{p.init}{Numeric; the initial p-value threshold (default: \code{0.001})}

\item{perm.method}{Character string indicating the permutation method.
Default: \code{'freedmanLane'}}

\item{part.method}{Character string; the method of partitioning the design
matrix into covariates of interest and nuisance. Default: \code{'beckmann'}}

\item{N}{Integer; number of permutations to create. Default: \code{5e3}}

\item{perms}{Matrix of permutations, if you would like to provide your own.
Default: \code{NULL}}

\item{symm.by}{Character string; how to create symmetric off-diagonal
elements. Default: \code{max}}

\item{alternative}{Character string, whether to do a two- or one-sided test.
Default: \code{'two.sided'}}

\item{long}{Logical indicating whether or not to return all permutation
results. Default: \code{FALSE}}

\item{...}{Arguments passed to \code{\link{brainGraph_GLM_design}}}

\item{object, x}{A \code{NBS} object}

\item{contrast}{Integer specifying the contrast to plot/summarize; defaults
to showing results for all contrasts}

\item{digits}{Integer specifying the number of digits to display for P-values}
}
\value{
An object of class \code{NBS} with some input arguments in addition
  to:
  \item{X}{The design matrix}
  \item{removed.subs}{Character vector of subject ID's removed due to
    incomplete data (if any)}
  \item{T.mat}{3-d array of (symmetric) numeric matrices containing the
    statistics for each edge}
  \item{p.mat}{3-d array of (symmetric) numeric matrices containing the
    P-values}
  \item{components}{List containing data tables of the observed and permuted
    connected component sizes and P-values}
  \item{rank,df.residual,qr,cov.unscaled}{The rank, residual degrees of
    freedom, QR decomposition, and unscaled covariance matrix of the design
    matrix}
}
\description{
Calculates the \emph{network-based statistic (NBS)}, which allows for
family-wise error (FWE) control over network data, introduced for brain MRI
data by Zalesky et al. Requires a three-dimensional array of all subjects'
connectivity matrices and a \code{data.table} of covariates, in addition to a
contrast matrix or list. A null distribution of the largest connected
component size is created by fitting a GLM to permuted data. For details, see
\code{\link{GLM}}.
}
\details{
When printing a \code{summary}, you can include arguments to
\code{\link[stats]{printCoefmat}}.
}
\note{
It is assumed that the order of the subjects in \code{covars} matches
that of the input array \code{A}. You will need to ensure that this is the
case. Prior to \code{v3.0.0}, the \code{covars} table was sorted by
\code{Study.ID} before creating the design matrix.
}
\examples{
\dontrun{
max.comp.nbs <- NBS(A.norm.sub[[1]], covars.dti, N=5e3)
}
}
\references{
Zalesky, A. and Fornito,  A. and Bullmore, E.T. (2010)
  Network-based statistic: identifying differences in brain networks.
  \emph{NeuroImage}, \bold{53(4)}, 1197--1207.
  \doi{10.1016/j.neuroimage.2010.06.041}
}
\seealso{
Other Group analysis functions: 
\code{\link{Bootstrapping}},
\code{\link{GLM}},
\code{\link{Mediation}},
\code{\link{brainGraph_permute}()},
\code{\link{mtpc}()}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Group analysis functions}
