% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{build_accounting_block}
\alias{build_accounting_block}
\title{Build accounting block for TMG}
\usage{
build_accounting_block(
  TMG_raw,
  zTMG_exo,
  zTMG_use,
  mu_tmg,
  sd_tmg,
  hard,
  sigma_delta
)
}
\arguments{
\item{TMG_raw}{Numeric vector. Original TMG series.}

\item{zTMG_exo}{Numeric vector. Exogenous z-scored TMG.}

\item{zTMG_use}{Numeric vector. TMG used in model (possibly orthogonalized).}

\item{mu_tmg}{Numeric. Training mean of TMG.}

\item{sd_tmg}{Numeric. Training SD of TMG.}

\item{hard}{Logical. Whether hard sum-to-zero constraint was used.}

\item{sigma_delta}{Numeric. Prior SD for wedge in original units.}
}
\value{
List with components:
  \describe{
    \item{tmg_byK}{Back-transformed TMG used in model}
    \item{tmg_exo}{Back-transformed exogenous TMG}
    \item{wedge_delta}{Difference (zero if hard=TRUE)}
    \item{sigma_delta_prior}{Prior SD for wedge}
    \item{note}{Description of constraint type}
  }
}
\description{
Creates accounting information for TMG transformations.
}
