% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sampleMVN}
\alias{sampleMVN}
\title{Sample mixture of multivariate normal distributions with batch effects}
\usage{
sampleMVN(
  X,
  K,
  B,
  labels,
  batch_vec,
  mu_proposal_window,
  cov_proposal_window,
  m_proposal_window,
  S_proposal_window,
  R,
  thin,
  concentration,
  m_scale,
  rho,
  theta,
  initial_mu,
  initial_cov,
  initial_m,
  initial_S,
  mu_initialised,
  cov_initialised,
  m_initialised,
  S_initialised,
  sample_m_scale
)
}
\arguments{
\item{X}{The data matrix to perform clustering upon (items to cluster in rows).}

\item{K}{The number of components to model (upper limit on the number of 
clusters found).}

\item{B}{The number of batches to model.}

\item{labels}{Vector item labels to initialise from.}

\item{batch_vec}{Observed batch labels.}

\item{mu_proposal_window}{The standard deviation for the Gaussian proposal
density of the cluster means.}

\item{cov_proposal_window}{The degrees of freedom for the Wishart proposal
density of the cluster covariances.}

\item{m_proposal_window}{The standard deviation for the Gaussian proposal
density of the batch mean effects.}

\item{S_proposal_window}{The rate for the Gamma proposal density of the 
batch scale.}

\item{R}{The number of iterations to run for.}

\item{thin}{thinning factor for samples recorded.}

\item{concentration}{Vector of concentrations for mixture weights
(recommended to be symmetric).}

\item{m_scale}{The scale hyperparameter for the batch shift prior 
distribution.}

\item{rho}{The shape of the prior distribution for the batch scale.}

\item{theta}{The scale of the prior distribution for the batch scale.}

\item{initial_mu}{A P x K matrix of initial values for the class means.}

\item{initial_cov}{A P x P x K cube of initial values for the class 
covariance matrices.}

\item{initial_m}{A P x B matrix of initial values for the batch shift 
effects.}

\item{initial_S}{A P x B matrix of initial values for the batch scales.}

\item{mu_initialised}{Bool indicating if the class means are initialised by
the user. If ``false`` then initial values are drawn from the prior 
distribution.}

\item{cov_initialised}{Bool indicating if the class covariance matrices are 
initialised by the user. If ``false`` then initial values are drawn from the
prior distribution.}

\item{m_initialised}{Bool indicating if the batch shift effects are 
initialised by the user. If ``false`` then initial values are drawn from the
prior distribution.}

\item{S_initialised}{Bool indicating if the batch scales are initialised by 
the user. If ``false`` then initial values are drawn from the prior 
distribution.}

\item{sample_m_scale}{Bool indicating if the hyperparameter on the batch 
shift effect is sampled or given as fixed.}
}
\value{
Named list of the different quantities drawn by the sampler.
}
\description{
Performs MCMC sampling for a mixture model with batch effects.
}
