% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leverage_test.R
\name{leverage_test}
\alias{leverage_test}
\title{Identify leverage points}
\usage{
leverage_test(model, n = stats::nobs(model), ttype = "half", threshold = NULL)
}
\arguments{
\item{model}{A fitted model object from the
\code{\link[stats]{lm}} function.}

\item{n}{The number of leverage points to return. The
default is all leverage points.}

\item{ttype}{Threshold type. The default is
\code{"half"}. The other options are \code{"2mean"} and
\code{"custom"}. See Details.}

\item{threshold}{A number between 0 and 1. Any
observation with a leverage value above this number is
declared a leverage point. This is automatically
determined unless \code{ttype = "custom"}.}
}
\value{
A vector of statistics
}
\description{
\code{leverage_test} returns the observations identified
as a leverage point based on a threshold.
}
\details{
If \code{ttype = "half"}, the threshold is \code{0.5}.

If \code{ttype = "2mean"}, the threshold is \eqn{2p/n},
where \eqn{p = }\code{length(stats::coef(model))} and
\eqn{n = }\code{stats::nobs(model)}, which is double the
mean leverage value.

If \code{ttype = "custom"} then the user must manually
specify \code{threshold}.
}
\examples{
lmod <- lm(price ~ sqft_living, data = home_sales)
# comparison of results using different threshold types
leverage_test(lmod)
leverage_test(lmod, ttype = "2mean", n = 7)
leverage_test(lmod, ttype = "custom", threshold = 0.1)
}
\seealso{
\code{\link[stats]{hatvalues}}
}
