% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_plot_lm.R
\name{index_plot_lm}
\alias{index_plot_lm}
\title{Index plot of statistics from of an \code{lm} object}
\usage{
index_plot_lm(
  model,
  stat,
  id_n = 3,
  add_reference = FALSE,
  ...,
  text_arglist = list(),
  abline_arglist = list(),
  extendrange_f = 0.08
)
}
\arguments{
\item{model}{A fitted model object from the
\code{\link[stats]{lm}} function.}

\item{stat}{A function that can be applied to an \code{lm}
object and returns a vector of observations for each
observation used to fit the model.}

\item{id_n}{The number of points to identify with labels.
The default is \code{3}.}

\item{add_reference}{A logical value indicating whether a
reference line should be added. The default is
\code{TRUE}.}

\item{...}{Additional arguments passed to the
\code{\link[graphics]{plot}} function.}

\item{text_arglist}{Additional arguments passed to the
\code{\link[graphics]{text}} function, which is used to
display the points that are identified.}

\item{abline_arglist}{A named list specifying additional
arguments passed to the \code{\link[graphics]{abline}}
function for the horizontal reference line added to the
plot.}

\item{extendrange_f}{Positive number(s) specifying the
fraction by which the range of the residuals should be
extended using the \code{\link[grDevices]{extendrange}}
function. If longer than one, \code{f[1]} is used on
the left and \code{f[2]} on the right.}
}
\description{
\code{index_plot_lm} creates an index plot of statistcs
from an \code{lm} object.
}
\examples{
lmod <- lm(Petal.Length ~ Sepal.Length + Species,
           data = iris)
# outlier plot
# number of observations
n <- stats::nobs(lmod)
# loo residual degrees of freedom
rdf <- stats::df.residual(lmod) - 1

h <- c(-1, 1) * stats::qt(0.05/(2 * n), df = rdf)
index_plot_lm(lmod, stat = stats::rstudent,
              abline_arglist = list(h = h))

# leverage plot
index_plot_lm(lmod, stat = stats::hatvalues, id_n = 1)
# Cook's distance
index_plot_lm(lmod, stat = stats::cooks.distance,
              id_n = 3)
}
\seealso{
\code{\link[graphics]{plot}},
  \code{\link[graphics]{text}},
  \code{\link[stats]{lm}},
  \code{\link[stats]{rstudent}},
  \code{\link[stats]{hatvalues}},
  \code{\link[stats]{cooks.distance}}
}
\author{
Joshua French
}
