% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_dbs.R
\name{update_database}
\alias{update_database}
\title{Update a local SQLite database from a GitHub release}
\usage{
update_database(
  owner,
  repo,
  asset_name,
  local_sqlite_path,
  tag = NULL,
  token = Sys.getenv("GITHUB_PAT"),
  algo = "sha256",
  update = FALSE
)
}
\arguments{
\item{owner}{GitHub repository owner.}

\item{repo}{GitHub repository name.}

\item{asset_name}{Name of the SQLite file in the release.}

\item{local_sqlite_path}{Path to the local SQLite database.}

\item{tag}{Optional release tag. If NULL, uses latest release.}

\item{token}{Optional GitHub token. Defaults to \code{Sys.getenv("GITHUB_PAT")}.}

\item{algo}{Hash algorithm to use (default: \code{"sha256"}).}

\item{update}{Logical; if TRUE, will download the latest database
when the local copy is outdated (default: FALSE).}
}
\value{
Invisibly returns TRUE if the local database is up to date,
FALSE if it is outdated (and possibly updated if \code{update = TRUE}).
}
\description{
Internal helper function that compares a local SQLite database
with a GitHub release and optionally downloads the latest version.
}
