% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pythonInterface.R
\name{ipython}
\alias{ipython}
\title{Write a File of Python Commands to Test Package Modules in Python}
\usage{
ipython(file, package, module = "", ..., RPython = TRUE,
  folder = "python")
}
\arguments{
\item{file}{A file name or open write connection.  The python commands generated will be written to this file.}

\item{package}{The R package containing the relevent module}

\item{module}{The file (module) to be imported.  Specifically, a command \code{"from ... import *"} will be generated.
Omit this argument or supply it as \code{""} to suppress this command, in which case explicit commands should be provided.}

\item{...}{Additional python commands to be appended to the output file.}

\item{RPython}{Should the path include the XRPython code, default \code{TRUE}, which is usually what you want.}

\item{folder}{The name of the folder in the installed package; the default is the suggested \code{"python"}; that is, the installed
version of folder \code{"inst/python"} in the source for the package.  Note that it's the installed version; changes to the source
code must be installed to show up in the output.}
}
\description{
A file of python commands will be written that set up an interactive Python session
having imported the contents from a file (module) of python code in an R package.
Typically, uploading such a file to \code{ipython} notebook allows the python code, along with additional or modified code, to
be tested directly without interfacing from R.
}
