% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeekGtexOrgan.R
\name{seek_gtex_organ}
\alias{seek_gtex_organ}
\title{Load and Process GTEX Phenotype Data to Retrieve Primary Site Counts}
\usage{
seek_gtex_organ(path = "./download_data/GTEX_phenotype")
}
\arguments{
\item{path}{The path to the GTEX phenotype data file. Default is "./download_data/GTEX_phenotype".}
}
\value{
A table representing the count of samples per primary site.
}
\description{
This function reads the GTEX phenotype data from a specified path, renames its columns for better readability,
and then returns a table of primary site counts.
}
\examples{
# Get the file path to the example data in the package
path <- system.file("extdata", "GTEX_phenotype_test", package = "TransProR")
# Call the `seek_gtex_organ` function with the path and print the result
SeekGtexOrgan <- seek_gtex_organ(path = path)

}
