% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrepEdgeR.R
\name{prep_edgeR}
\alias{prep_edgeR}
\title{Prepare edgeR DEG data for plotting}
\usage{
prep_edgeR(input_path, output_name = NULL)
}
\arguments{
\item{input_path}{Path to the RDS file containing the edgeR DEG data frame.}

\item{output_name}{Name for the processed data frame, also used as the RDS file name.}
}
\value{
A data frame with processed edgeR DEG data.
}
\description{
This function reads an edgeR DEG data frame from an RDS file, filters it using
\code{\link{deg_filter}} function, adjusts the logFC to absolute values, adds a pseudo-count to PValue,
and transforms PValue for plotting. The final data frame is returned and
optionally saved to a new RDS file.
}
\examples{
edgeR_file <- system.file("extdata",
                          "DEG_edgeR_test.rds",
                          package = "TransProR")
edgeR <- prep_edgeR(edgeR_file)

}
