% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lex2bin.R
\name{lex2bin}
\alias{lex2bin}
\title{Lexicographic order to binary order}
\usage{
lex2bin(v)
}
\arguments{
\item{v}{A characteristic function, as a vector in lexicographic order.}
}
\value{
The characteristic function, as a vector in binary order.
}
\description{
Given a characteristic function in lexicographic order, this function returns the characteristic function in binary order.
}
\details{
Lexicographic order arranges coalitions in ascending order according to size, and applies lexicographic order to break ties among coalitions of the same size. The binary order position of a coalition \eqn{S\in 2^N} is given by \eqn{\sum_{i\in S} 2^{i-1}}.
}
\examples{
v <- seq(1:31)
lex2bin(v)
bin2lex(lex2bin(v))==v
}
\seealso{
\link{bin2lex}, \link{codebin2lex}, \link{codelex2bin}
}
