% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corecentervalue.R
\name{corecentervalue}
\alias{corecentervalue}
\title{Core-center}
\usage{
corecentervalue(v, binary = FALSE, tol = 1e-12)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{tol}{A tolerance parameter, as a non-negative number. By default, \code{tol=1e-12}.}
}
\value{
The core-center, as a vector.
}
\description{
Given a game, this function computes its core center.
}
\details{
The core of a game \eqn{v\in G^N} is the set of all its stable imputations:
\deqn{C(v)=\{x\in\mathbb{R}^n : x(N)=v(N), x(S)\ge v(S)\ \forall S \in 2^N\},}
where \eqn{x(S)=\sum_{i\in S} x_i}. A game is said to be balanced if its core is not empty.

The core-center of a balanced game \eqn{v}, \eqn{CC(v)}, is defined as the expectation
of the uniform distribution over \eqn{C(v)}, and thus can be interpreted
as the centroid or center of gravity of \eqn{C(v)}.
Let \eqn{\mu} be the \eqn{(n-1)}-dimensional Lebesgue measure and let \eqn{V(C)=\mu(C(v))}
be the volume (measure) of the core. If \eqn{V(C)>0}, then, for each \eqn{i\in N},
\deqn{CC_i(v)=\frac{1}{V(C)}\int_{C(v)}x_i d\mu}.
}
\examples{
v1 <- claimsgame(E=8,d=c(3,5,6))
corecentervalue(v1)
plotcoreset(v1,solutions="corecenter")

v2 <- c(0,0,0,0,0,0,0,0,1,4,1,3,6,8,10)
corecentervalue(v2)
plotcoreset(v2,solutions="corecenter")

# What if the game is not full-dimensional because of a dummy player?
v3 <- c(440,0,0,0,440,440,440,15,14,7,455,454,447,60,500)
dummynull(v3) # player 1 is a dummy in v3, so the core is degenerate
# For coredimension to detect that, tolerance has to be appropriate:
coredimension(v=v3,tol=100*.Machine$double.eps) # tolerance too small
coredimension(v=v3) # default tolerance, 1e-12, big enough

# Now how to compute the corecenter?
# When given a degenerate game, corecentervalue computes an approximation:
( cc.approx <- corecentervalue(v=v3) ) # approximate core-center
# However, knowing that player 1 is a dummy and that the core-center assigns
# dummies their individual worth...
v3.without1 <- subgame(v=v3,S=14) # subgame without player 1
( cc.exact <- c(v3[1],corecentervalue(v3.without1)) ) # "exact" core-center

# Plotting both results:
plotcoreset(v3,allocations=rbind(cc.approx,cc.exact),projected=TRUE)
}
\references{
Gonzalez-Díaz, J. & Sánchez-Rodríguez, E. (2007). A natural selection from the core of a TU game: the core-center. International Journal of Game Theory, 36(1), 27-46.
}
\seealso{
\link{balancedcheck}, \link{corecenterhitrun}, \link{coredimension}, \link{corevertices}, \link{corevertices234}
}
