% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learn_network.R
\name{learn_network}
\alias{learn_network}
\title{Learn network model}
\usage{
learn_network(
  X,
  A = NA,
  method = "correlation",
  resampling_method = "stability_selection",
  numB = 100,
  cutoff = 0,
  pars = list(m = ncol(X), B = NA, alpha_stab = 0.05, alpha_pred = 0.05, size_weight =
    "linear", use_resampling = FALSE, prescreen_size = nrow(X) - 1, prescreen_type =
    "correlation", stab_test = "exact", pred_score = "mse", variable_importance =
    "scaled_coefficient"),
  verbose = 0,
  cores = 1
)
}
\arguments{
\item{X}{data matrix. Numeric matrix of size n times d, where
columns correspond to individual variables.}

\item{A}{stabilizing variable. Numeric vector of length n which
can be interpreted as a factor.}

\item{method}{specifies which method to use. "SR" for Stabilized
Regression (both standard and predictive version), "SRstab" for
only the standard version of SR, "SRpred" for only the
predictive version of SR, "OLS" for linear OLS regression,
"lasso" for Lasso and "correlation" for correlation test.}

\item{resampling_method}{specifies which resampling method to
use. Should be one of "none", "stability_selection" or
"permutation".}

\item{numB}{number of resamples to use.}

\item{cutoff}{tuning parameter used in stability selection to
determine which sets count as selected.}

\item{pars}{list of additional parameters passed to SR
regression. See \link{StabilizedRegression} for more details.}

\item{verbose}{0 for no output, 1 for text output and 2 for text
and diagnostic plots.}

\item{cores}{number of cores to use in resampling step.}
}
\value{
A list consisting of the following
  elements

\item{Amat}{adjacency matrix, where Amat[i,j] is a score (depending on the resampling_method) for the edge from i to j. For "stability_selection" scores correspond to selection probabilities, for "permutation" scores correspond to permutation p-values and for "none" scores correspond to variable importance of the method.}
\item{p}{Total number of potential edges which can be used to compute upper bound on false discovery rate (only computed if resampling_method == "stability_selection").}
\item{qest}{Average number of selected edges in stability selection, which can be used to compute upper bound on false discovery rate (only computed if resampling_method == "stability_selection").}

If method=="SR" result is a list with two entries SRstab and
SRpred each consisting of a list of the form described above.
}
\description{
Learn a network model for a collection of variables.
}
\details{
Uses StabilizedRegression, Lasso or correlation to construct a
node-wise network between all variables in X.
}
\examples{
## Example
set.seed(1)
X1 <- rnorm(200)
X2 <- X1 + rnorm(200)
X3 <- 0.5 * X1 + X2 + 0.2 * c(rnorm(100), rnorm(100)+20)

X <- cbind(X1, X2, X3)
A <- as.factor(rep(c(0, 1), each=100))

network <- learn_network(X, A, method="SR", resampling_method="none")

print(network[[1]]$Amat)
print(network[[2]]$Amat)
}
\author{
Niklas Pfister
}
